% CREATE_POBLATION Creates a population of chromosomes.
% The arguments to the function are
%     NVARS: Number of variables
%     FitnessFcn: Fitness function
%     inputs: 8 alignment of the main alignment methodologies
%     options: Options structure used by the GA

function pop = create_population(NVARS, FitnessFcn, options, inputs, headers)

% Create cell array where first poblation will be stored
totalPopulationSize = sum(options.PopulationSize);
pop = cell(totalPopulationSize,1);

% Create the first poblation
Ninputs = length(inputs);
for i=1:Ninputs     
    % Read multiple sequence alignment
    multipleAlign = struct('msa',[],'codification',[]);
    [hMSA sMSA] = multialignread(char(inputs(i).file));
    % Prepare the alignment structure
    sMSA = char(sMSA);
    sMSA(sMSA == '.' | sMSA == '-')='*';  
    % Sort the sequence names 
    [is, pos] = ismember(headers,hMSA);
    sMSA = sMSA(pos,:);

    % Save each chromosome in a position of the structure
    multipleAlign.msa = sMSA;
    multipleAlign.codification = codify_chromosome(sMSA);
    pop{i} = multipleAlign;
end

% Complete the first poblation with the crossover operator
for i=Ninputs+1:2:totalPopulationSize    
    position = [randi(i-1) randi(i-1) randi(i-1) randi(i-1)];    
    cross=crossover(position, options, NVARS, [], [], pop);
    pop{i} = cross{1};
    if(i<100)
        pop{i+1} = cross{2};
    end
end